Scriptname SSB_SoS_ReadBook_WSN extends ObjectReference  

Actor Property PlayerRef Auto
FormList property SSB_SoS_ReadBooks Auto
Perk Property SSB_SoS_Skill Auto  
Perk Property BlackBookPerk Auto
String Property SSB_SoS_SkillName Auto
Perk Property SSB_SoS_WSN_Xarxes Auto
MagicEffect Property SSB_SoS_WSN_Praying Auto
String Property SSB_SoS_ThisBook Auto

string[] ReadBooks
int nextPosition = 0


event onRead()

	;Wait until after the menu
	While (Utility.IsInMenuMode())
		Utility.wait(1)

	EndWhile

	;Initiliaze array if it hasn't been
	if ReadBooks.Length < 1
		ReadBooks = new String[90]
	
	endIf
	
	
	;Return if the player has already read this book
	if (!hasReadBook(SSB_SoS_ThisBook))
		Utility.Wait(0.1)
		Debug.Notification("You've learned as much as you can from this book.")
		return
		
	;Book not in list so execute
	else
		;Adds the perk to the player
		Utility.Wait(0.1)
		PlayerRef.addPerk(SSB_SoS_Skill)

		
		;Adds the book to the form list so it only counts once
		ReadBooks[nextPosition] = SSB_SoS_ThisBook
		nextPosition += 1

		;Adds an additional rank if the Player has the Black Book Perk
		if PlayerRef.hasPerk(BlackBookPerk)
			Debug.Notification("Your Scholar's Insight into this tome allows you to significantly increase your " + SSB_SoS_SkillName + " skill faster." )
			PlayerRef.addPerk(SSB_SoS_Skill)		

		else 
			Debug.Notification("The knowledge in this tome allows you to increase your " + SSB_SoS_SkillName + " skill faster.")

		endif
		
		;If the player has the Xarxes boon in Wintersun and is currently praying
		if (PlayerRef.HasMagicEffect(SSB_SoS_WSN_Praying) && PlayerRef.HasPerk(SSB_SoS_WSN_Xarxes))
			Debug.Notification("Your devotion to Xarxes further increases your understanding of " + SSB_SoS_SkillName + ".")
			PlayerRef.addPerk(SSB_SoS_Skill)

		endif
		
	endif

endEvent

;Checks if book is in array
bool function hasReadBook (string bookToCheck)

	int i = 0
	while i < nextPosition
		if ReadBooks[i] == bookToCheck
			return i

		else
			i += 1

		endif

	endWhile
 
	return -1
 
endFunction

